/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.drools.KnowledgeBase;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.base.MapGlobalResolver;
import org.drools.command.Command;
import org.drools.common.EndOperationListener;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.WorkingMemoryAction;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.runtime.Calendars;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.Globals;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.rule.Agenda;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionClock;
import org.drools.time.TimerService;
import org.drools.time.TimerServiceFactory;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessRuntimeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulProcessSession
implements StatefulKnowledgeSession,
InternalKnowledgeRuntime {
    private KnowledgeBase kbase;
    private InternalProcessRuntime processRuntime;
    private WorkItemManager workItemManager;
    private KnowledgeSessionConfiguration sessionConfiguration;
    private Environment environment;
    private TimerService timerService;
    protected Queue<WorkingMemoryAction> actionQueue;
    private int id;
    private MapGlobalResolver globals = new MapGlobalResolver();

    public StatefulProcessSession(KnowledgeBase kbase, KnowledgeSessionConfiguration sessionConfiguration, Environment environment) {
        this.kbase = kbase;
        this.sessionConfiguration = sessionConfiguration;
        this.environment = environment;
        this.timerService = TimerServiceFactory.getTimerService((SessionConfiguration)sessionConfiguration);
        this.processRuntime = new ProcessRuntimeImpl(this);
        this.actionQueue = new LinkedList<WorkingMemoryAction>();
    }

    @Override
    public void abortProcessInstance(long processInstanceId) {
        this.processRuntime.abortProcessInstance(processInstanceId);
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.processRuntime.getProcessInstance(processInstanceId);
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.processRuntime.getProcessInstances();
    }

    @Override
    public void signalEvent(String type, Object event) {
        this.processRuntime.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, long processInstanceId) {
        this.processRuntime.signalEvent(type, event, processInstanceId);
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.processRuntime.startProcess(processId);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.processRuntime.startProcess(processId, parameters);
    }

    @Override
    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.processRuntime.createProcessInstance(processId, parameters);
    }

    @Override
    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.processRuntime.startProcessInstance(processInstanceId);
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.processRuntime.addEventListener(listener);
    }

    @Override
    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.processRuntime.getProcessEventListeners();
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.processRuntime.removeEventListener(listener);
    }

    @Override
    public KnowledgeBase getKnowledgeBase() {
        return this.kbase;
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = ((SessionConfiguration)this.sessionConfiguration).getWorkItemManagerFactory().createWorkItemManager(this);
            Map<String, WorkItemHandler> workItemHandlers = ((SessionConfiguration)this.sessionConfiguration).getWorkItemHandlers();
            if (workItemHandlers != null) {
                for (Map.Entry<String, WorkItemHandler> entry : workItemHandlers.entrySet()) {
                    this.workItemManager.registerWorkItemHandler(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.workItemManager;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InternalProcessRuntime getProcessRuntime() {
        return this.processRuntime;
    }

    @Override
    public KnowledgeSessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public void startOperation() {
    }

    @Override
    public void endOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeQueuedActions() {
        try {
            this.startOperation();
            if (this.actionQueue.isEmpty()) return;
            WorkingMemoryAction action = null;
            while ((action = this.actionQueue.poll()) != null) {
                try {
                    action.execute(this);
                }
                catch (Exception e) {
                    throw new RuntimeDroolsException("Unexpected exception executing action " + action.toString(), e);
                    return;
                }
            }
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Queue<WorkingMemoryAction> getActionQueue() {
        return this.actionQueue;
    }

    @Override
    public void queueWorkingMemoryAction(WorkingMemoryAction action) {
        this.actionQueue.add(action);
    }

    @Override
    public void dispose() {
        if (this.timerService != null) {
            this.timerService.shutdown();
        }
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setEndOperationListener(EndOperationListener listener) {
    }

    @Override
    public int fireAllRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int fireAllRules(int max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fireUntilHalt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T execute(Command<T> command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Calendars getCalendars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Channel> getChannels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getGlobal(String identifier) {
        return this.globals.get(identifier);
    }

    @Override
    public Globals getGlobals() {
        return this.globals;
    }

    public SessionClock getSessionClock() {
        return (SessionClock)((Object)this.timerService);
    }

    @Override
    public void registerChannel(String name, Channel channel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerExitPoint(String name, ExitPoint exitPoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobal(String identifier, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterChannel(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterExitPoint(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Agenda getAgenda() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryResults getQueryResults(String query, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void halt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEntryPointId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFactCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(FactHandle factHandle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> getObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> getObjects(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FactHandle insert(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retract(FactHandle handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(FactHandle handle, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
    }

    @Override
    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return new ArrayList<AgendaEventListener>();
    }

    @Override
    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return new ArrayList<WorkingMemoryEventListener>();
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
    }

    @Override
    public long getLastIdleTimestamp() {
        throw new UnsupportedOperationException();
    }
}

